//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "3d.h"
#include "stereo.h"
#include "fgrafika3d3.h"
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
 il_rozwiniec = 0;
}
//---------------------------------------------------------------------------
// Inicjowanie okienka
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
//  Zmieniono nastaw ktrego z elementw interfejsu
void TForm1::odczytaj_parametry( void)
{
 double r, fi, teta;
 int a;
 double k = M_PI / 180.;        //stopnie na radiany

 sp = (StylPatrzenia)RadioGroup2 -> ItemIndex;
 if( sp == Anaglif)
 {
    Lkolor = clRed;
    Rkolor = clAqua;
 }
 else
 {
    Lkolor = Rkolor = clBlack;
 }
 baza = (double)TrackBar4 -> Position / 10.;

 r = TrackBar1 -> Position;
 fi = TrackBar2 -> Position;
 teta = TrackBar3 -> Position;
 a = RadioGroup1 -> ItemIndex + 1;

 p_obs.x = r * sin( k * teta) * cos( k * fi);
 p_obs.y = r * sin( k * teta) * sin( k * fi);
 p_obs.z = r * cos( k * teta);

 if( a != il_rozwiniec)     //zmieniono poziom rozwijania?
 {
    formula = "UA";         //Jeli tak, rozwi od pocztku
    il_rozwiniec = a;
    for( int i = 0; i < il_rozwiniec; i++)
        rozwin();
 }
}
//---------------------------------------------------------------------------
//  Grafika
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 TPunkt p0(0, 0, 0);        //zaczepienie grafiki
 rysuj( p0, 0, 90, 5);      //interpretacja formuy tekstowej
}
//---------------------------------------------------------------------------
//  Wzrost formuy
void TForm1 :: rozwin( void)
{
 String tmp;
 int i, len = formula.Length();
 char c;

 for( i = 1; i <= len; i ++)
 {
    c = formula[ i];
    switch( c)
    {
     case 'A':
                tmp += "AGLADRADRAGRALALALARA";
                break;
     case 'R':                  //skr w poziomie w prawo
                tmp += "R";
                break;
     case 'L':                  //skr w poziomie w lewo
                tmp += "L";
                break;
     case 'G':                  //skr w pionie w gr
                tmp += "G";
                break;
     case 'D':                  //skr w pionie w d
                tmp += "D";
                break;
     case 'U':                  //wprowad skalowanie wymiaru
                tmp += "UV";
                break;
     case 'V':                  //skaluj wymiar
                tmp += "V";
                break;
    }
 }
 formula = tmp;
 Caption = formula;
}
//---------------------------------------------------------------------------
//  Interpretuj formu.
void TForm1 :: rysuj( TPunkt p0, double fi, double teta, double dlg)
{
 TStereo projektor( p_obs,       //pozycja obserwatora
        0, 0, PaintBox1 -> Width, PaintBox1 -> Height,  //okno ekranowe
        baza,                    //odlego midzy oczami
        PaintBox1 -> Canvas,     //aparat graficzny
        sp,                      //styl projekcji stereo
        0.3);                    //odlego oka od paszczyzny obrazowej
 int i, len = formula.Length();
 TPunkt p1;                      //koniec odcinka krelonego z punktu p0
 char c;
 double k = M_PI / 180.;         //stopnie na radiany

 for( i = 1; i <= len; i ++)
 {
    c = formula[ i];
    switch( c)
    {
     case 'A':
                p1.x = p0.x + dlg*sin(k*teta)*cos(k*fi);
                p1.y = p0.y + dlg*sin(k*teta)*sin(k*fi);
                p1.z = p0.z + dlg*cos(k*teta);
                projektor.linia_stereo( p0, p1, Lkolor, Rkolor);
                p0 = p1;
                break;
     case 'R':                  //skr w poziomie w prawo
                fi -= 90;
                break;
     case 'L':                  //skr w poziomie w lewo
                fi += 90;
                break;
     case 'G':                  //skr w pionie w gr
                teta -= 90;
                break;
     case 'D':                  //skr w pionie w d
                teta += 90;
                break;
     case 'U':                  //wprowad skalowanie wymiaru
                break;
     case 'V':                  //skaluj wymiar
                dlg /= 3.0;
                break;
    }
 }
}
//---------------------------------------------------------------------------
//  Zmieniono nastawy interfejsu
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();        //odrysuj grafik
}
//---------------------------------------------------------------------------

